/*
 * Decompiled with CFR 0.152.
 */
package rlmixins.mixin.vanilla;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.chunk.storage.AnvilChunkLoader;
import net.minecraft.world.chunk.storage.RegionFileCache;
import org.apache.logging.log4j.Logger;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={AnvilChunkLoader.class})
public abstract class AnvilChunkLoaderMixin {
    @Shadow
    @Final
    public File field_75825_d;
    @Shadow
    @Final
    private static Logger field_151505_a;
    @Shadow
    private boolean field_183014_e;
    @Shadow
    private final Map<ChunkPos, NBTTagCompound> field_75828_a = new HashMap<ChunkPos, NBTTagCompound>();
    private final Map<ChunkPos, NBTTagCompound> chunksInWrite = new HashMap<ChunkPos, NBTTagCompound>();

    @Shadow
    private void func_183013_b(ChunkPos pos, NBTTagCompound compound) throws IOException {
    }

    private synchronized void queueChunkToSave(ChunkPos pos, NBTTagCompound data) {
        this.field_75828_a.put(pos, data);
    }

    private synchronized Map.Entry<ChunkPos, NBTTagCompound> fetchChunkToWrite() {
        if (this.field_75828_a.isEmpty()) {
            return null;
        }
        Set<Map.Entry<ChunkPos, NBTTagCompound>> entrySet = this.field_75828_a.entrySet();
        Iterator<Map.Entry<ChunkPos, NBTTagCompound>> iter = entrySet.iterator();
        Map.Entry<ChunkPos, NBTTagCompound> entry = iter.next();
        iter.remove();
        this.chunksInWrite.put(entry.getKey(), entry.getValue());
        return entry;
    }

    private synchronized void retireChunkToWrite(ChunkPos pos, NBTTagCompound data) {
        this.chunksInWrite.remove(pos);
    }

    private synchronized NBTTagCompound reloadChunkFromSaveQueues(ChunkPos pos) {
        NBTTagCompound data = this.field_75828_a.get(pos);
        if (data != null) {
            return data;
        }
        return this.chunksInWrite.get(pos);
    }

    private synchronized boolean chunkExistInSaveQueues(ChunkPos pos) {
        return this.field_75828_a.containsKey(pos) || this.chunksInWrite.containsKey(pos);
    }

    @Redirect(method={"loadChunk__Async"}, at=@At(value="INVOKE", target="Ljava/util/Map;get(Ljava/lang/Object;)Ljava/lang/Object;", ordinal=0, remap=false), remap=false)
    private Object pullChunkToSave(Map lChunksToSave, Object lpos) {
        return this.reloadChunkFromSaveQueues((ChunkPos)lpos);
    }

    @Inject(method={"isChunkGeneratedAt"}, at={@At(value="HEAD")}, cancellable=true)
    private void overrideIsChunkGeneratedAt(int x, int z, CallbackInfoReturnable<Boolean> ci) {
        ChunkPos chunkpos = new ChunkPos(x, z);
        boolean exists = this.chunkExistInSaveQueues(chunkpos);
        ci.setReturnValue((Object)(exists || RegionFileCache.func_191064_f((File)this.field_75825_d, (int)x, (int)z) ? 1 : 0));
    }

    @Redirect(method={"addChunkToPending"}, at=@At(value="INVOKE", target="Ljava/util/Set;contains(Ljava/lang/Object;)Z", remap=false))
    private boolean overrideAddChunkToPending(Set lChunksBeingSaved, Object lPos, ChunkPos pos, NBTTagCompound compound) {
        this.queueChunkToSave(pos, compound);
        return true;
    }

    @Inject(method={"writeNextIO"}, at={@At(value="HEAD")}, cancellable=true)
    private void overrideWriteNextIO(CallbackInfoReturnable<Boolean> ci) {
        Map.Entry<ChunkPos, NBTTagCompound> entry = this.fetchChunkToWrite();
        if (entry == null) {
            if (this.field_183014_e) {
                field_151505_a.info("ThreadedAnvilChunkStorage ({}): All chunks are saved", new Object[]{this.field_75825_d.getName()});
            }
            ci.setReturnValue((Object)false);
            return;
        }
        ChunkPos chunkpos = entry.getKey();
        NBTTagCompound nbttagcompound = entry.getValue();
        try {
            this.func_183013_b(chunkpos, nbttagcompound);
        }
        catch (Exception exception) {
            field_151505_a.error("Failed to save chunk", (Throwable)exception);
        }
        this.retireChunkToWrite(chunkpos, nbttagcompound);
        ci.setReturnValue((Object)true);
    }
}

